<?php

namespace App\Utils;

use App\Models\Agence;
use App\Models\Client;
use App\Models\commandes;
use App\Models\Facture;
use App\Models\Stock;
use App\Models\SellInventaire;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ContactService{


    public function contactTransaction(){
        return Client::with('factures')
                ->select('clients.fullname', 'clients.phone_number',
                         'clients.address',
                         DB::raw('SUM(t.total_price) as total_price'))
                ->join('factures as t', 't.contact_id', 'clients.id')
                ->get();
    }

    public function getStockInitial($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $st = Facture::select(DB::raw('SUM(factures.total_price) as price, a.designation, SUM(so.qte_stock) as theorique, SUM(a.qte) as initial'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->join('articles as a', 'a.id', 's.article_id')
                ->join('stocks as so', 'so.article_id', 'a.id')
                ->where('factures.entreprise_id', $entreprise)
                ->whereBetween('transact_date', [$start, $end])
                ->first();

        return $st;
    }

    public function getallAchats($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = commandes::select(DB::raw('SUM(f.total_price) as price, SUM(s.quantity) as qty'))
                ->join('factures as f', 'f.id', 'commandes.article_id')
                ->join('sells as s', 's.transaction_id', 'f.id')
                ->where('f.entreprise_id', $entreprise)
                ->whereBetween('transact_date', [$start, $end])
                ->first();

        return $cmd;
    }

    public function getallVente($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::select(DB::raw('SUM(s.quantity) as qty, SUM(s.total) as total'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->where('factures.entreprise_id', $entreprise)
                ->whereBetween('transact_date', [$start, $end])
                ->first();

        return $cmd;
    }

    public function getallArticleE(){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::with('Sells')
                ->select(DB::raw('a.id as article_id, a.designation as name, SUM(s.quantity) as entree'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->join('articles as a', 'a.id', 's.article_id')
                ->where('factures.entreprise_id', $entreprise)
                ->where('factures.bill_type', '=', 'commande')
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }
    public function getallArticleS(){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::with('Sells')
                ->select(DB::raw('a.id as article_id, a.designation as name, SUM(s.quantity) as sortie'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->join('articles as a', 'a.id', 's.article_id')
                ->where('factures.entreprise_id', $entreprise)
                ->where('factures.bill_type', '=', 'vente')
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }

    
    public function getminarticle(){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Stock::with('article')
                ->select(DB::raw('a.id as article_id, a.designation as name, Min(stocks.id) as first_id, stocks.qte_stock as qty'))
                ->join('articles as a', 'a.id', 'stocks.article_id')
                ->where('a.entreprise_id', $entreprise)
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }

    public function getmaxSellInv(){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = SellInventaire::with('article')
                ->select(DB::raw('a.id as article_id, a.designation as name, MAX(sell_inventaires.id) as invId, sell_inventaires.stock_theorique as qty'))
                ->join('articles as a', 'a.id', 'sell_inventaires.article_id')
                ->where('a.entreprise_id', $entreprise)
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }

    public function getallVenteD($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::select(DB::raw('SUM(s.quantity) as qty, SUM(s.total) as total'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->where('factures.entreprise_id', $entreprise)
                ->whereBetween('transact_date', [$start, $end])
                ->first();

        return $cmd;
    }

    public function getallArticleED($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::with('Sells')
                ->select(DB::raw('a.id as article_id, a.designation as name, SUM(s.quantity) as entree'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->join('articles as a', 'a.id', 's.article_id')
                ->where('factures.entreprise_id', $entreprise)
                ->where('factures.bill_type', '=', 'commande')
                ->whereBetween('factures.transact_date', [$start, $end])
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }
    public function getallArticleSD($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Facture::with('Sells')
                ->select(DB::raw('a.id as article_id, a.designation as name, SUM(s.quantity) as sortie'))
                ->join('sells as s', 's.transaction_id', 'factures.id')
                ->join('articles as a', 'a.id', 's.article_id')
                ->where('factures.entreprise_id', $entreprise)
                ->where('factures.bill_type', '=', 'vente')
                ->whereBetween('factures.transact_date', [$start, $end])
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }

    
    public function getminarticleD(){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = Stock::with('article')
                ->select(DB::raw('a.id as article_id, a.designation as name, Min(stocks.id) as first_id, stocks.qte_stock as qty'))
                ->join('articles as a', 'a.id', 'stocks.article_id')
                ->where('a.entreprise_id', $entreprise)
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }

    public function getmaxSellInvD($start, $end){
        $entreprise = Auth::user()->entreprise_id;
        $cmd = SellInventaire::with('article')
                ->select(DB::raw('a.id as article_id, a.designation as name, MAX(sell_inventaires.id) as invId, sell_inventaires.stock_theorique as qty'))
                ->join('articles as a', 'a.id', 'sell_inventaires.article_id')
                ->where('a.entreprise_id', $entreprise)
                ->whereBetween('sell_inventaires.created_at', [$start, $end])
                ->groupBy('a.id')
                ->get();

        return $cmd;
    }


    public function getContactTotalRepay($contact_id){
        $repay = Facture::select(DB::raw('SUM(repayment) as repay'))
                        ->where('contact_id', $contact_id)
                        ->groupBy('contact_id')
                        ->first();

        return $repay;
    }

    public function getlastDueTransaction($contact_id){
        $last_id = Facture::all()->max('id');
        //$partial = 'partial';
        $last_due = Facture::select('rest')
                    ->where('contact_id', $contact_id)
                    ->where('id', $last_id)
                    ->where('rest', '>', '0')
                    //->groupBy('id')
                    ->first('rest');

        return $last_due;

    }

    public function getLastTransaction($contact_id){
        $last_id = Facture::all()->max('id');

        $last_trans = Facture::all()
        ->where('ccontact_id', $contact_id)
        ->where('id', $last_id)
        //->groupBy('id')
        ->first();

        return $last_trans;
    }

    public function getLastTransactionRepay($contact_id){
        $last_id = Facture::all()->max('id');

        $last_trans = Facture::all()
        ->where('contact_id', $contact_id)
        ->where('repayment', '>', '0')
        //->groupBy('id')
        ->first();

        return $last_trans;
    }



}
