<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class VariationTemplate
 * 
 * @property int $id
 * @property string $name
 * @property int $business_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class VariationTemplate extends Model
{
	protected $table = 'variation_templates';


	/**
	 * The attributes that aren't mass assignable.
	 *
	 * @var array
	 */
	protected $guarded = ['id'];
	protected $casts = [
		'business_id' => 'int'
	];

	protected $fillable = [
		'name',
		'business_id'
	];
	/**
	 * Get the attributes for the variation.
	 */
	public function values()
	{
		return $this->hasMany(VariationValueTemplate::class);
	}
}
