<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class VariationLocationDetail
 * 
 * @property int $id
 * @property int $product_id
 * @property int $product_variation_id
 * @property int $variation_id
 * @property int $location_id
 * @property float $qty_available
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class VariationLocationDetail extends Model
{
	protected $table = 'variation_location_details';

	protected $casts = [
		'product_id' => 'int',
		'product_variation_id' => 'int',
		'variation_id' => 'int',
		'location_id' => 'int',
		'qty_available' => 'float'
	];

	protected $fillable = [
		'product_id',
		'product_variation_id',
		'variation_id',
		'location_id',
		'qty_available'
	];
}
