<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class VariationGroupPrice
 * 
 * @property int $id
 * @property int $variation_id
 * @property int $price_group_id
 * @property float $price_inc_tax
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class VariationGroupPrice extends Model
{
	protected $table = 'variation_group_prices';

	protected $casts = [
		'variation_id' => 'int',
		'price_group_id' => 'int',
		'price_inc_tax' => 'float'
	];

	protected $fillable = [
		'variation_id',
		'price_group_id',
		'price_inc_tax'
	];
}
