<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Variation
 * 
 * @property int $id
 * @property string $name
 * @property int $product_id
 * @property string|null $sub_sku
 * @property int $product_variation_id
 * @property int|null $variation_value_id
 * @property float|null $default_purchase_price
 * @property float $dpp_inc_tax
 * @property float $profit_percent
 * @property float|null $default_sell_price
 * @property float|null $sell_price_inc_tax
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * @property string|null $combo_variations
 *
 * @package App\Models
 */
class Variation extends Model
{
	use SoftDeletes;
	protected $table = 'variations';

	protected $casts = [
		'product_id' => 'int',
		'product_variation_id' => 'int',
		'variation_value_id' => 'int',
		'default_purchase_price' => 'float',
		'dpp_inc_tax' => 'float',
		'profit_percent' => 'float',
		'default_sell_price' => 'float',
		'sell_price_inc_tax' => 'float'
	];

	protected $fillable = [
		'name',
		'product_id',
		'sub_sku',
		'product_variation_id',
		'variation_value_id',
		'default_purchase_price',
		'dpp_inc_tax',
		'profit_percent',
		'default_sell_price',
		'sell_price_inc_tax',
		'combo_variations'
	];
}
