<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Unit
 * 
 * @property int $id
 * @property int $business_id
 * @property string $actual_name
 * @property string $short_name
 * @property bool $allow_decimal
 * @property int|null $base_unit_id
 * @property float|null $base_unit_multiplier
 * @property int $created_by
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Unit extends Model
{
	use SoftDeletes;
	protected $table = 'units';

	protected $casts = [
		'business_id' => 'int',
		'allow_decimal' => 'bool',
		'base_unit_id' => 'int',
		'base_unit_multiplier' => 'float',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'actual_name',
		'short_name',
		'allow_decimal',
		'base_unit_id',
		'base_unit_multiplier',
		'created_by'
	];

	/**
	 * Return list of units for a business
	 *
	 * @param int $business_id
	 * @param boolean $show_none = true
	 *
	 * @return array
	 */
	public static function forDropdown($business_id, $show_none = false, $only_base = true)
	{
		$query = Unit::where('business_id', $business_id);
		if ($only_base) {
			$query->whereNull('base_unit_id');
		}

		$units = $query->select(DB::raw('CONCAT(actual_name, " (", short_name, ")") as name'), 'id')->get();
		$dropdown = $units->pluck('name', 'id');
		if ($show_none) {
			$dropdown->prepend(__('messages.please_select'), '');
		}

		return $dropdown;
	}

	public function sub_units()
	{
		return $this->hasMany(Unit::class, 'base_unit_id');
	}

	public function base_unit()
	{
		return $this->belongsTo(Unit::class, 'base_unit_id');
	}
}
