<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TypesOfService
 * 
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property int $business_id
 * @property string|null $location_price_group
 * @property float|null $packing_charge
 * @property string|null $packing_charge_type
 * @property bool $enable_custom_fields
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class TypesOfService extends Model
{
	protected $table = 'types_of_services';

	protected $casts = [
		'business_id' => 'int',
		'packing_charge' => 'float',
		'enable_custom_fields' => 'bool'
	];

	protected $fillable = [
		'name',
		'description',
		'business_id',
		'location_price_group',
		'packing_charge',
		'packing_charge_type',
		'enable_custom_fields'
	];
}
