<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TransactionSellLinesPurchaseLine
 * 
 * @property int $id
 * @property int|null $sell_line_id
 * @property int|null $stock_adjustment_line_id
 * @property int $purchase_line_id
 * @property float $quantity
 * @property float $qty_returned
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class TransactionSellLinesPurchaseLine extends Model
{
	protected $table = 'transaction_sell_lines_purchase_lines';

	protected $casts = [
		'sell_line_id' => 'int',
		'stock_adjustment_line_id' => 'int',
		'purchase_line_id' => 'int',
		'quantity' => 'float',
		'qty_returned' => 'float'
	];

	protected $fillable = [
		'sell_line_id',
		'stock_adjustment_line_id',
		'purchase_line_id',
		'quantity',
		'qty_returned'
	];
}
