<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TransactionSellLine
 * 
 * @property int $id
 * @property int $transaction_id
 * @property int $product_id
 * @property int $variation_id
 * @property float $quantity
 * @property float $quantity_returned
 * @property float $unit_price_before_discount
 * @property float|null $unit_price
 * @property string|null $line_discount_type
 * @property float $line_discount_amount
 * @property float|null $unit_price_inc_tax
 * @property float $item_tax
 * @property int|null $tax_id
 * @property int|null $discount_id
 * @property int|null $lot_no_line_id
 * @property string|null $sell_line_note
 * @property int|null $res_service_staff_id
 * @property string|null $res_line_order_status
 * @property int|null $parent_sell_line_id
 * @property string $children_type
 * @property int|null $sub_unit_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class TransactionSellLine extends Model
{
	protected $table = 'transaction_sell_lines';

	protected $casts = [
		'transaction_id' => 'int',
		'product_id' => 'int',
		'variation_id' => 'int',
		'quantity' => 'float',
		'quantity_returned' => 'float',
		'unit_price_before_discount' => 'float',
		'unit_price' => 'float',
		'line_discount_amount' => 'float',
		'unit_price_inc_tax' => 'float',
		'item_tax' => 'float',
		'tax_id' => 'int',
		'discount_id' => 'int',
		'lot_no_line_id' => 'int',
		'res_service_staff_id' => 'int',
		'parent_sell_line_id' => 'int',
		'sub_unit_id' => 'int'
	];

	protected $fillable = [
		'transaction_id',
		'product_id',
		'variation_id',
		'quantity',
		'quantity_returned',
		'unit_price_before_discount',
		'unit_price',
		'line_discount_type',
		'line_discount_amount',
		'unit_price_inc_tax',
		'item_tax',
		'tax_id',
		'discount_id',
		'lot_no_line_id',
		'sell_line_note',
		'res_service_staff_id',
		'res_line_order_status',
		'parent_sell_line_id',
		'children_type',
		'sub_unit_id'
	];
}
