<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TransactionPayment
 * 
 * @property int $id
 * @property int|null $transaction_id
 * @property int|null $business_id
 * @property bool $is_return
 * @property float $amount
 * @property string|null $method
 * @property string|null $transaction_no
 * @property string|null $card_transaction_number
 * @property string|null $card_number
 * @property string|null $card_type
 * @property string|null $card_holder_name
 * @property string|null $card_month
 * @property string|null $card_year
 * @property string|null $card_security
 * @property string|null $cheque_number
 * @property string|null $bank_account_number
 * @property Carbon|null $paid_on
 * @property int $created_by
 * @property bool $is_advance
 * @property int|null $payment_for
 * @property int|null $parent_id
 * @property string|null $note
 * @property string|null $document
 * @property string|null $payment_ref_no
 * @property int|null $account_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class TransactionPayment extends Model
{
	protected $table = 'transaction_payments';

	protected $casts = [
		'transaction_id' => 'int',
		'business_id' => 'int',
		'is_return' => 'bool',
		'amount' => 'float',
		'paid_on' => 'datetime',
		'created_by' => 'int',
		'is_advance' => 'bool',
		'payment_for' => 'int',
		'parent_id' => 'int',
		'account_id' => 'int'
	];

	protected $fillable = [
		'transaction_id',
		'business_id',
		'is_return',
		'amount',
		'method',
		'transaction_no',
		'card_transaction_number',
		'card_number',
		'card_type',
		'card_holder_name',
		'card_month',
		'card_year',
		'card_security',
		'cheque_number',
		'bank_account_number',
		'paid_on',
		'created_by',
		'is_advance',
		'payment_for',
		'parent_id',
		'note',
		'document',
		'payment_ref_no',
		'account_id'
	];
}
