<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Transaction
 * 
 * @property int $id
 * @property int $business_id
 * @property int|null $location_id
 * @property int|null $res_table_id
 * @property int|null $res_waiter_id
 * @property string|null $res_order_status
 * @property string|null $type
 * @property string|null $sub_type
 * @property string $status
 * @property bool $is_quotation
 * @property string|null $payment_status
 * @property string|null $adjustment_type
 * @property int|null $contact_id
 * @property int|null $customer_group_id
 * @property string|null $invoice_no
 * @property string|null $ref_no
 * @property string|null $subscription_no
 * @property string|null $subscription_repeat_on
 * @property Carbon $transaction_date
 * @property float $total_before_tax
 * @property int|null $tax_id
 * @property float $tax_amount
 * @property string|null $discount_type
 * @property float|null $discount_amount
 * @property int $rp_redeemed
 * @property float $rp_redeemed_amount
 * @property string|null $shipping_details
 * @property string|null $shipping_address
 * @property string|null $shipping_status
 * @property string|null $delivered_to
 * @property float $shipping_charges
 * @property string|null $additional_notes
 * @property string|null $staff_note
 * @property float $round_off_amount
 * @property float $final_total
 * @property int|null $expense_category_id
 * @property int|null $expense_for
 * @property int|null $commission_agent
 * @property string|null $document
 * @property bool $is_direct_sale
 * @property bool $is_suspend
 * @property float $exchange_rate
 * @property float|null $total_amount_recovered
 * @property int|null $transfer_parent_id
 * @property int|null $return_parent_id
 * @property int|null $opening_stock_product_id
 * @property int $created_by
 * @property int|null $updated_by
 * @property int|null $import_batch
 * @property Carbon|null $import_time
 * @property int|null $types_of_service_id
 * @property float|null $packing_charge
 * @property string|null $packing_charge_type
 * @property string|null $service_custom_field_1
 * @property string|null $service_custom_field_2
 * @property string|null $service_custom_field_3
 * @property string|null $service_custom_field_4
 * @property bool $is_created_from_api
 * @property int $rp_earned
 * @property string|null $order_addresses
 * @property bool $is_recurring
 * @property float|null $recur_interval
 * @property string|null $recur_interval_type
 * @property int|null $recur_repetitions
 * @property Carbon|null $recur_stopped_on
 * @property int|null $recur_parent_id
 * @property string|null $invoice_token
 * @property int|null $pay_term_number
 * @property string|null $pay_term_type
 * @property int|null $selling_price_group_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Transaction extends Model
{
	protected $table = 'transactions';

	protected $casts = [
		'business_id' => 'int',
		'location_id' => 'int',
		'res_table_id' => 'int',
		'res_waiter_id' => 'int',
		'is_quotation' => 'bool',
		'contact_id' => 'int',
		'customer_group_id' => 'int',
		'transaction_date' => 'datetime',
		'total_before_tax' => 'float',
		'tax_id' => 'int',
		'tax_amount' => 'float',
		'discount_amount' => 'float',
		'rp_redeemed' => 'int',
		'rp_redeemed_amount' => 'float',
		'shipping_charges' => 'float',
		'round_off_amount' => 'float',
		'final_total' => 'float',
		'expense_category_id' => 'int',
		'expense_for' => 'int',
		'commission_agent' => 'int',
		'is_direct_sale' => 'bool',
		'is_suspend' => 'bool',
		'exchange_rate' => 'float',
		'total_amount_recovered' => 'float',
		'transfer_parent_id' => 'int',
		'return_parent_id' => 'int',
		'opening_stock_product_id' => 'int',
		'created_by' => 'int',
		'updated_by' => 'int',
		'import_batch' => 'int',
		'import_time' => 'datetime',
		'types_of_service_id' => 'int',
		'packing_charge' => 'float',
		'is_created_from_api' => 'bool',
		'rp_earned' => 'int',
		'is_recurring' => 'bool',
		'recur_interval' => 'float',
		'recur_repetitions' => 'int',
		'recur_stopped_on' => 'datetime',
		'recur_parent_id' => 'int',
		'pay_term_number' => 'int',
		'selling_price_group_id' => 'int'
	];

	protected $hidden = [
		'invoice_token'
	];

	protected $fillable = [
		'business_id',
		'location_id',
		'res_table_id',
		'res_waiter_id',
		'res_order_status',
		'type',
		'sub_type',
		'status',
		'is_quotation',
		'payment_status',
		'adjustment_type',
		'contact_id',
		'customer_group_id',
		'invoice_no',
		'ref_no',
		'subscription_no',
		'subscription_repeat_on',
		'transaction_date',
		'total_before_tax',
		'tax_id',
		'tax_amount',
		'discount_type',
		'discount_amount',
		'rp_redeemed',
		'rp_redeemed_amount',
		'shipping_details',
		'shipping_address',
		'shipping_status',
		'delivered_to',
		'shipping_charges',
		'additional_notes',
		'staff_note',
		'round_off_amount',
		'final_total',
		'expense_category_id',
		'expense_for',
		'commission_agent',
		'document',
		'is_direct_sale',
		'is_suspend',
		'exchange_rate',
		'total_amount_recovered',
		'transfer_parent_id',
		'return_parent_id',
		'opening_stock_product_id',
		'created_by',
		'updated_by',
		'import_batch',
		'import_time',
		'types_of_service_id',
		'packing_charge',
		'packing_charge_type',
		'service_custom_field_1',
		'service_custom_field_2',
		'service_custom_field_3',
		'service_custom_field_4',
		'is_created_from_api',
		'rp_earned',
		'order_addresses',
		'is_recurring',
		'recur_interval',
		'recur_interval_type',
		'recur_repetitions',
		'recur_stopped_on',
		'recur_parent_id',
		'invoice_token',
		'pay_term_number',
		'pay_term_type',
		'selling_price_group_id'
	];

	public function purchase_lines()
	{
		return $this->hasMany(PurchaseLine::class);
	}

	public function sell_lines()
	{
		return $this->hasMany(TransactionSellLine::class);
	}

	public function contact()
	{
		return $this->belongsTo(Contact::class, 'contact_id');
	}

	public function payment_lines()
	{
		return $this->hasMany(TransactionPayment::class, 'transaction_id');
	}

	public function location()
	{
		return $this->belongsTo(BusinessLocation::class, 'location_id');
	}

	public function business()
	{
		return $this->belongsTo(Business::class, 'business_id');
	}

	public function tax()
	{
		return $this->belongsTo(TaxRate::class, 'tax_id');
	}

	public function stock_adjustment_lines()
	{
		return $this->hasMany(StockAdjustmentLine::class);
	}

	public function sales_person()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function return_parent()
	{
		return $this->hasOne(Transaction::class, 'return_parent_id');
	}

	public function table()
	{
		return $this->belongsTo(ResTable::class, 'res_table_id');
	}

	public function service_staff()
	{
		return $this->belongsTo(User::class, 'res_waiter_id');
	}

	public function recurring_invoices()
	{
		return $this->hasMany(Transaction::class, 'recur_parent_id');
	}

	public function recurring_parent()
	{
		return $this->hasOne(Transaction::class, 'id', 'recur_parent_id');
	}

	public function price_group()
	{
		return $this->belongsTo(SellingPriceGroup::class, 'selling_price_group_id');
	}

	public function types_of_service()
	{
		return $this->belongsTo(TypesOfService::class, 'types_of_service_id');
	}

	/**
	 * Retrieves documents path if exists
	 */
	public function getDocumentPathAttribute()
	{
		$path = !empty($this->document) ? asset('/uploads/documents/' . $this->document) : null;

		return $path;
	}

	/**
	 * Removes timestamp from document name
	 */
	public function getDocumentNameAttribute()
	{
		$document_name = !empty(explode("_", $this->document, 2)[1]) ? explode("_", $this->document, 2)[1] : $this->document;
		return $document_name;
	}

	public function subscription_invoices()
	{
		return $this->hasMany(Transaction::class, 'recur_parent_id');
	}

	/**
	 * Shipping address custom method
	 */
	public function shipping_address($array = false)
	{
		$addresses = !empty($this->order_addresses) ? json_decode($this->order_addresses, true) : [];

		$shipping_address = [];

		if (!empty($addresses['shipping_address'])) {
			if (!empty($addresses['shipping_address']['shipping_name'])) {
				$shipping_address['name'] = $addresses['shipping_address']['shipping_name'];
			}
			if (!empty($addresses['shipping_address']['company'])) {
				$shipping_address['company'] = $addresses['shipping_address']['company'];
			}
			if (!empty($addresses['shipping_address']['shipping_address_line_1'])) {
				$shipping_address['address_line_1'] = $addresses['shipping_address']['shipping_address_line_1'];
			}
			if (!empty($addresses['shipping_address']['shipping_address_line_2'])) {
				$shipping_address['address_line_2'] = $addresses['shipping_address']['shipping_address_line_2'];
			}
			if (!empty($addresses['shipping_address']['shipping_city'])) {
				$shipping_address['city'] = $addresses['shipping_address']['shipping_city'];
			}
			if (!empty($addresses['shipping_address']['shipping_state'])) {
				$shipping_address['state'] = $addresses['shipping_address']['shipping_state'];
			}
			if (!empty($addresses['shipping_address']['shipping_country'])) {
				$shipping_address['country'] = $addresses['shipping_address']['shipping_country'];
			}
			if (!empty($addresses['shipping_address']['shipping_zip_code'])) {
				$shipping_address['zipcode'] = $addresses['shipping_address']['shipping_zip_code'];
			}
		}

		if ($array) {
			return $shipping_address;
		} else {
			return implode(', ', $shipping_address);
		}
	}

	/**
	 * billing address custom method
	 */
	public function billing_address($array = false)
	{
		$addresses = !empty($this->order_addresses) ? json_decode($this->order_addresses, true) : [];

		$billing_address = [];

		if (!empty($addresses['billing_address'])) {
			if (!empty($addresses['billing_address']['billing_name'])) {
				$billing_address['name'] = $addresses['billing_address']['billing_name'];
			}
			if (!empty($addresses['billing_address']['company'])) {
				$billing_address['company'] = $addresses['billing_address']['company'];
			}
			if (!empty($addresses['billing_address']['billing_address_line_1'])) {
				$billing_address['address_line_1'] = $addresses['billing_address']['billing_address_line_1'];
			}
			if (!empty($addresses['billing_address']['billing_address_line_2'])) {
				$billing_address['address_line_2'] = $addresses['billing_address']['billing_address_line_2'];
			}
			if (!empty($addresses['billing_address']['billing_city'])) {
				$billing_address['city'] = $addresses['billing_address']['billing_city'];
			}
			if (!empty($addresses['billing_address']['billing_state'])) {
				$billing_address['state'] = $addresses['billing_address']['billing_state'];
			}
			if (!empty($addresses['billing_address']['billing_country'])) {
				$billing_address['country'] = $addresses['billing_address']['billing_country'];
			}
			if (!empty($addresses['billing_address']['billing_zip_code'])) {
				$billing_address['zipcode'] = $addresses['billing_address']['billing_zip_code'];
			}
		}

		if ($array) {
			return $billing_address;
		} else {
			return implode(', ', $billing_address);
		}
	}

	public function cash_register_payments()
	{
		return $this->hasMany(CashRegisterTransaction::class);
	}

	public function media()
	{
		return $this->morphMany(Media::class, 'model');
	}

	public function transaction_for()
	{
		return $this->belongsTo(User::class, 'expense_for');
	}

	/**
	 * Returns the list of discount types.
	 */
	public static function discountTypes()
	{
		return [
			'fixed' => __('lang_v1.fixed'),
			'percentage' => __('lang_v1.percentage')
		];
	}

	public static function transactionTypes()
	{
		return  [
			'sell' => __('sale.sale'),
			'purchase' => __('lang_v1.purchase'),
			'sell_return' => __('lang_v1.sell_return'),
			'purchase_return' =>  __('lang_v1.purchase_return'),
			'opening_balance' => __('lang_v1.opening_balance'),
			'payment' => __('lang_v1.payment')
		];
	}

	public static function getPaymentStatus($transaction)
	{
		$payment_status = $transaction->payment_status;

		if (in_array($payment_status, ['partial', 'due']) && !empty($transaction->pay_term_number) && !empty($transaction->pay_term_type)) {
			$transaction_date = Carbon::parse($transaction->transaction_date);
			$due_date = $transaction->pay_term_type == 'days' ? $transaction_date->addDays($transaction->pay_term_number) : $transaction_date->addMonths($transaction->pay_term_number);
			$now = Carbon::now();
			if ($now->gt($due_date)) {
				$payment_status = $payment_status == 'due' ? 'overdue' : 'partial-overdue';
			}
		}

		return $payment_status;
	}

	/**
	 * Due date custom attribute
	 */
	public function getDueDateAttribute()
	{
		$due_date = null;
		if (!empty($this->pay_term_type) && !empty($this->pay_term_number)) {
			$transaction_date = Carbon::parse($this->transaction_date);
			$due_date = $this->pay_term_type == 'days' ? $transaction_date->addDays($this->pay_term_number) : $transaction_date->addMonths($this->pay_term_number);
		}

		return $due_date;
	}
}
