<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class TaxRate
 * 
 * @property int $id
 * @property int $business_id
 * @property string $name
 * @property float $amount
 * @property bool $is_tax_group
 * @property int $created_by
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Collection|Business[] $businesses
 * @property GroupSubTax|null $group_sub_tax
 *
 * @package App\Models
 */
class TaxRate extends Model
{
	use SoftDeletes;
	protected $table = 'tax_rates';

	protected $casts = [
		'business_id' => 'int',
		'amount' => 'float',
		'is_tax_group' => 'bool',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'name',
		'amount',
		'is_tax_group',
		'created_by'
	];

	public function businesses()
	{
		return $this->hasMany(Business::class, 'default_sales_tax');
	}

	public function group_sub_tax()
	{
		return $this->hasOne(GroupSubTax::class, 'tax_id');
	}
}
