<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class System
 * 
 * @property int $id
 * @property string $key
 * @property string|null $value
 *
 * @package App\Models
 */
class System extends Model
{
	protected $table = 'system';
	public $timestamps = false;

	protected $fillable = [
		'key',
		'value'
	];
	/**
	 * Return the value of the property
	 *
	 * @param $key string
	 * @return mixed
	 */
	public static function getProperty($key)
	{
		$row = System::where('key', $key)
			->first();

		if (isset($row->value)) {
			return $row->value;
		} else {
			return null;
		}
	}

	/**
	 * Return the value of the multiple properties
	 *
	 * @param $keys array
	 * @return array
	 */
	public static function getProperties($keys, $pluck = false)
	{
		if ($pluck == true) {
			return System::whereIn('key', $keys)
				->pluck('value', 'key');
		} else {
			return System::whereIn('key', $keys)
				->get()
				->toArray();
		}
	}

	/**
	 * Return the system default currency details
	 *
	 * @param void
	 * @return object
	 */
	public static function getCurrency()
	{
		$c_id = System::where('key', 'app_currency_id')
			->first()
			->value;

		$currency = Currency::find($c_id);

		return $currency;
	}

	/**
	 * Set the property
	 *
	 * @param $key
	 * @param $value
	 *
	 * @return void
	 */
	public static function setProperty($key, $value)
	{
		System::where('key', $key)
			->update(['value' => $value]);
	}

	/**
	 * Remove the specified property
	 *
	 * @param $key
	 * @return void
	 */
	public static function removeProperty($key)
	{
		System::where('key', $key)
			->delete();
	}

	/**
	 * Add a new property, if exist update the value
	 *
	 * @param $key
	 * @param $value
	 * @return void
	 */
	public static function addProperty($key, $value)
	{
		System::updateOrCreate(
			['key' => $key],
			['value' => $value]
		);
	}
}
