<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SuperadminFrontendPage
 * 
 * @property int $id
 * @property string|null $title
 * @property string $slug
 * @property string $content
 * @property bool $is_shown
 * @property int|null $menu_order
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class SuperadminFrontendPage extends Model
{
	protected $table = 'superadmin_frontend_pages';

	protected $casts = [
		'is_shown' => 'bool',
		'menu_order' => 'int'
	];

	protected $fillable = [
		'title',
		'slug',
		'content',
		'is_shown',
		'menu_order'
	];
}
