<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Subscription
 * 
 * @property int $id
 * @property int $business_id
 * @property int $package_id
 * @property Carbon|null $start_date
 * @property Carbon|null $trial_end_date
 * @property Carbon|null $end_date
 * @property float $package_price
 * @property string $package_details
 * @property int $created_id
 * @property string|null $paid_via
 * @property string|null $payment_transaction_id
 * @property string $status
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Subscription extends Model
{
	use SoftDeletes;
	protected $table = 'subscriptions';

	protected $casts = [
		'business_id' => 'int',
		'package_id' => 'int',
		'start_date' => 'datetime',
		'trial_end_date' => 'datetime',
		'end_date' => 'datetime',
		'package_price' => 'float',
		'created_id' => 'int'
	];

	protected $fillable = [
		'business_id',
		'package_id',
		'start_date',
		'trial_end_date',
		'end_date',
		'package_price',
		'package_details',
		'created_id',
		'paid_via',
		'payment_transaction_id',
		'status'
	];
}
