<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class StockAdjustmentLine
 * 
 * @property int $id
 * @property int $transaction_id
 * @property int $product_id
 * @property int $variation_id
 * @property float $quantity
 * @property float|null $unit_price
 * @property int|null $removed_purchase_line
 * @property int|null $lot_no_line_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class StockAdjustmentLine extends Model
{
	protected $table = 'stock_adjustment_lines';

	protected $casts = [
		'transaction_id' => 'int',
		'product_id' => 'int',
		'variation_id' => 'int',
		'quantity' => 'float',
		'unit_price' => 'float',
		'removed_purchase_line' => 'int',
		'lot_no_line_id' => 'int'
	];

	protected $fillable = [
		'transaction_id',
		'product_id',
		'variation_id',
		'quantity',
		'unit_price',
		'removed_purchase_line',
		'lot_no_line_id'
	];
}
