<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class SellingPriceGroup
 * 
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property int $business_id
 * @property bool $is_active
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class SellingPriceGroup extends Model
{
	use SoftDeletes;
	protected $table = 'selling_price_groups';

	protected $casts = [
		'business_id' => 'int',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'name',
		'description',
		'business_id',
		'is_active'
	];

	public function scopeActive($query)
	{
		return $query->where('selling_price_groups.is_active', 1);
	}

	/**
	 * Return list of selling price groups
	 *
	 * @param int $business_id
	 *
	 * @return array
	 */
	public static function forDropdown($business_id)
	{
		$price_groups = SellingPriceGroup::where('business_id', $business_id)
			->active()
			->get();

		$dropdown = [];

		if (auth()->user()->can('access_default_selling_price')) {
			$dropdown[0] = __('lang_v1.default_selling_price');
		}

		foreach ($price_groups as $price_group) {
			if (auth()->user()->can('selling_price_group.' . $price_group->id)) {
				$dropdown[$price_group->id] = $price_group->name;
			}
		}
		return $dropdown;
	}

	/**
	 * Counts total number of selling price groups
	 *
	 * @param int $business_id
	 *
	 * @return array
	 */
	public static function countSellingPriceGroups($business_id)
	{
		$count = SellingPriceGroup::where('business_id', $business_id)
			->active()
			->count();

		return $count;
	}
}
