<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Role
 * 
 * @property int $id
 * @property string $name
 * @property string $guard_name
 * @property int $business_id
 * @property bool $is_default
 * @property bool $is_service_staff
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Role extends Model
{
	protected $table = 'roles';

	protected $casts = [
		'business_id' => 'int',
		'is_default' => 'bool',
		'is_service_staff' => 'bool'
	];

	protected $fillable = [
		'name',
		'guard_name',
		'business_id',
		'is_default',
		'is_service_staff'
	];
}
