<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ResTable
 * 
 * @property int $id
 * @property int $business_id
 * @property int $location_id
 * @property string $name
 * @property string|null $description
 * @property int $created_by
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class ResTable extends Model
{
	use SoftDeletes;
	protected $table = 'res_tables';

	protected $casts = [
		'business_id' => 'int',
		'location_id' => 'int',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'location_id',
		'name',
		'description',
		'created_by'
	];
}
