<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PurchaseLine
 * 
 * @property int $id
 * @property int $transaction_id
 * @property int $product_id
 * @property int $variation_id
 * @property float $quantity
 * @property float $pp_without_discount
 * @property float $discount_percent
 * @property float $purchase_price
 * @property float $purchase_price_inc_tax
 * @property float $item_tax
 * @property int|null $tax_id
 * @property float $quantity_sold
 * @property float $quantity_adjusted
 * @property float $quantity_returned
 * @property float $mfg_quantity_used
 * @property Carbon|null $mfg_date
 * @property Carbon|null $exp_date
 * @property string|null $lot_number
 * @property int|null $sub_unit_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class PurchaseLine extends Model
{
	protected $table = 'purchase_lines';

	protected $casts = [
		'transaction_id' => 'int',
		'product_id' => 'int',
		'variation_id' => 'int',
		'quantity' => 'float',
		'pp_without_discount' => 'float',
		'discount_percent' => 'float',
		'purchase_price' => 'float',
		'purchase_price_inc_tax' => 'float',
		'item_tax' => 'float',
		'tax_id' => 'int',
		'quantity_sold' => 'float',
		'quantity_adjusted' => 'float',
		'quantity_returned' => 'float',
		'mfg_quantity_used' => 'float',
		'mfg_date' => 'datetime',
		'exp_date' => 'datetime',
		'sub_unit_id' => 'int'
	];

	protected $fillable = [
		'transaction_id',
		'product_id',
		'variation_id',
		'quantity',
		'pp_without_discount',
		'discount_percent',
		'purchase_price',
		'purchase_price_inc_tax',
		'item_tax',
		'tax_id',
		'quantity_sold',
		'quantity_adjusted',
		'quantity_returned',
		'mfg_quantity_used',
		'mfg_date',
		'exp_date',
		'lot_number',
		'sub_unit_id'
	];

	public function transaction()
	{
		return $this->belongsTo(Transaction::class);
	}

	public function product()
	{
		return $this->belongsTo(Product::class, 'product_id');
	}

	public function variations()
	{
		return $this->belongsTo(Variation::class, 'variation_id');
	}

	/**
	 * Set the quantity.
	 *
	 * @param  string  $value
	 * @return float $value
	 */
	public function getQuantityAttribute($value)
	{
		return (float)$value;
	}

	/**
	 * Get the unit associated with the purchase line.
	 */
	public function sub_unit()
	{
		return $this->belongsTo(Unit::class, 'sub_unit_id');
	}

	/**
	 * Give the quantity remaining for a particular
	 * purchase line.
	 *
	 * @return float $value
	 */
	public function getQuantityRemainingAttribute()
	{
		return (float)($this->quantity - $this->quantity_used);
	}

	/**
	 * Give the sum of quantity sold, adjusted, returned.
	 *
	 * @return float $value
	 */
	public function getQuantityUsedAttribute()
	{
		return (float)($this->quantity_sold + $this->quantity_adjusted + $this->quantity_returned + $this->mfg_quantity_used);
	}
}
