<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductVariation
 * 
 * @property int $id
 * @property int|null $variation_template_id
 * @property string $name
 * @property int $product_id
 * @property bool $is_dummy
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class ProductVariation extends Model
{
	protected $table = 'product_variations';

	protected $casts = [
		'variation_template_id' => 'int',
		'product_id' => 'int',
		'is_dummy' => 'bool'
	];

	protected $fillable = [
		'variation_template_id',
		'name',
		'product_id',
		'is_dummy'
	];
}
