<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductRack
 * 
 * @property int $id
 * @property int $business_id
 * @property int $location_id
 * @property int $product_id
 * @property string|null $rack
 * @property string|null $row
 * @property string|null $position
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class ProductRack extends Model
{
	protected $table = 'product_racks';

	protected $casts = [
		'business_id' => 'int',
		'location_id' => 'int',
		'product_id' => 'int'
	];

	protected $fillable = [
		'business_id',
		'location_id',
		'product_id',
		'rack',
		'row',
		'position'
	];
}
