<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Printer
 * 
 * @property int $id
 * @property int $business_id
 * @property string $name
 * @property string $connection_type
 * @property string $capability_profile
 * @property string|null $char_per_line
 * @property string|null $ip_address
 * @property string|null $port
 * @property string|null $path
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 *
 * @package App\Models
 */
class Printer extends Model
{
	protected $table = 'printers';

	protected $casts = [
		'business_id' => 'int',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'name',
		'connection_type',
		'capability_profile',
		'char_per_line',
		'ip_address',
		'port',
		'path',
		'created_by'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}
}
