<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Package
 * 
 * @property int $id
 * @property string $name
 * @property string $description
 * @property int $location_count
 * @property int $user_count
 * @property int $product_count
 * @property bool $bookings
 * @property bool $kitchen
 * @property bool $order_screen
 * @property bool $tables
 * @property int $invoice_count
 * @property string $interval
 * @property int $interval_count
 * @property int $trial_days
 * @property float $price
 * @property string $custom_permissions
 * @property int $created_by
 * @property int $sort_order
 * @property bool $is_active
 * @property bool $is_private
 * @property bool $is_one_time
 * @property bool $enable_custom_link
 * @property string|null $custom_link
 * @property string|null $custom_link_text
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Package extends Model
{
	use SoftDeletes;
	protected $table = 'packages';

	protected $casts = [
		'location_count' => 'int',
		'user_count' => 'int',
		'product_count' => 'int',
		'bookings' => 'bool',
		'kitchen' => 'bool',
		'order_screen' => 'bool',
		'tables' => 'bool',
		'invoice_count' => 'int',
		'interval_count' => 'int',
		'trial_days' => 'int',
		'price' => 'float',
		'created_by' => 'int',
		'sort_order' => 'int',
		'is_active' => 'bool',
		'is_private' => 'bool',
		'is_one_time' => 'bool',
		'enable_custom_link' => 'bool'
	];

	protected $fillable = [
		'name',
		'description',
		'location_count',
		'user_count',
		'product_count',
		'bookings',
		'kitchen',
		'order_screen',
		'tables',
		'invoice_count',
		'interval',
		'interval_count',
		'trial_days',
		'price',
		'custom_permissions',
		'created_by',
		'sort_order',
		'is_active',
		'is_private',
		'is_one_time',
		'enable_custom_link',
		'custom_link',
		'custom_link_text'
	];
}
