<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Medium
 * 
 * @property int $id
 * @property int $business_id
 * @property string $file_name
 * @property string|null $description
 * @property int|null $uploaded_by
 * @property string $model_type
 * @property int $model_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Medium extends Model
{
	protected $table = 'media';

	protected $casts = [
		'business_id' => 'int',
		'uploaded_by' => 'int',
		'model_id' => 'int'
	];

	protected $fillable = [
		'business_id',
		'file_name',
		'description',
		'uploaded_by',
		'model_type',
		'model_id'
	];
}
