<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InvoiceScheme
 * 
 * @property int $id
 * @property int $business_id
 * @property string $name
 * @property string $scheme_type
 * @property string|null $prefix
 * @property int|null $start_number
 * @property int $invoice_count
 * @property int|null $total_digits
 * @property bool $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 * @property Collection|BusinessLocation[] $business_locations
 *
 * @package App\Models
 */
class InvoiceScheme extends Model
{
	protected $table = 'invoice_schemes';

	protected $casts = [
		'business_id' => 'int',
		'start_number' => 'int',
		'invoice_count' => 'int',
		'total_digits' => 'int',
		'is_default' => 'bool'
	];

	protected $fillable = [
		'business_id',
		'name',
		'scheme_type',
		'prefix',
		'start_number',
		'invoice_count',
		'total_digits',
		'is_default'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	public function business_locations()
	{
		return $this->hasMany(BusinessLocation::class);
	}
}
