<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InvoiceLayout
 * 
 * @property int $id
 * @property string $name
 * @property string|null $header_text
 * @property string|null $invoice_no_prefix
 * @property string|null $quotation_no_prefix
 * @property string|null $invoice_heading
 * @property string|null $sub_heading_line1
 * @property string|null $sub_heading_line2
 * @property string|null $sub_heading_line3
 * @property string|null $sub_heading_line4
 * @property string|null $sub_heading_line5
 * @property string|null $invoice_heading_not_paid
 * @property string|null $invoice_heading_paid
 * @property string|null $quotation_heading
 * @property string|null $sub_total_label
 * @property string|null $discount_label
 * @property string|null $tax_label
 * @property string|null $total_label
 * @property string|null $round_off_label
 * @property string|null $total_due_label
 * @property string|null $paid_label
 * @property bool $show_client_id
 * @property string|null $client_id_label
 * @property string|null $client_tax_label
 * @property string|null $date_label
 * @property string|null $date_time_format
 * @property bool $show_time
 * @property bool $show_brand
 * @property bool $show_sku
 * @property bool $show_cat_code
 * @property bool $show_expiry
 * @property bool $show_lot
 * @property bool $show_image
 * @property bool $show_sale_description
 * @property string|null $sales_person_label
 * @property bool $show_sales_person
 * @property string|null $table_product_label
 * @property string|null $table_qty_label
 * @property string|null $table_unit_price_label
 * @property string|null $table_subtotal_label
 * @property string|null $cat_code_label
 * @property string|null $logo
 * @property bool $show_logo
 * @property bool $show_business_name
 * @property bool $show_location_name
 * @property bool $show_landmark
 * @property bool $show_city
 * @property bool $show_state
 * @property bool $show_zip_code
 * @property bool $show_country
 * @property bool $show_mobile_number
 * @property bool $show_alternate_number
 * @property bool $show_email
 * @property bool $show_tax_1
 * @property bool $show_tax_2
 * @property bool $show_barcode
 * @property bool $show_payments
 * @property bool $show_customer
 * @property string|null $customer_label
 * @property bool $show_reward_point
 * @property string|null $highlight_color
 * @property string|null $footer_text
 * @property string|null $module_info
 * @property string|null $common_settings
 * @property bool $is_default
 * @property int $business_id
 * @property string|null $design
 * @property string|null $cn_heading
 * @property string|null $cn_no_label
 * @property string|null $cn_amount_label
 * @property string|null $table_tax_headings
 * @property bool $show_previous_bal
 * @property string|null $prev_bal_label
 * @property string|null $change_return_label
 * @property string|null $product_custom_fields
 * @property string|null $contact_custom_fields
 * @property string|null $location_custom_fields
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 * @property Collection|BusinessLocation[] $business_locations
 *
 * @package App\Models
 */
class InvoiceLayout extends Model
{
	protected $table = 'invoice_layouts';

	protected $casts = [
		'show_client_id' => 'bool',
		'show_time' => 'bool',
		'show_brand' => 'bool',
		'show_sku' => 'bool',
		'show_cat_code' => 'bool',
		'show_expiry' => 'bool',
		'show_lot' => 'bool',
		'show_image' => 'bool',
		'show_sale_description' => 'bool',
		'show_sales_person' => 'bool',
		'show_logo' => 'bool',
		'show_business_name' => 'bool',
		'show_location_name' => 'bool',
		'show_landmark' => 'bool',
		'show_city' => 'bool',
		'show_state' => 'bool',
		'show_zip_code' => 'bool',
		'show_country' => 'bool',
		'show_mobile_number' => 'bool',
		'show_alternate_number' => 'bool',
		'show_email' => 'bool',
		'show_tax_1' => 'bool',
		'show_tax_2' => 'bool',
		'show_barcode' => 'bool',
		'show_payments' => 'bool',
		'show_customer' => 'bool',
		'show_reward_point' => 'bool',
		'is_default' => 'bool',
		'business_id' => 'int',
		'show_previous_bal' => 'bool'
	];

	protected $fillable = [
		'name',
		'header_text',
		'invoice_no_prefix',
		'quotation_no_prefix',
		'invoice_heading',
		'sub_heading_line1',
		'sub_heading_line2',
		'sub_heading_line3',
		'sub_heading_line4',
		'sub_heading_line5',
		'invoice_heading_not_paid',
		'invoice_heading_paid',
		'quotation_heading',
		'sub_total_label',
		'discount_label',
		'tax_label',
		'total_label',
		'round_off_label',
		'total_due_label',
		'paid_label',
		'show_client_id',
		'client_id_label',
		'client_tax_label',
		'date_label',
		'date_time_format',
		'show_time',
		'show_brand',
		'show_sku',
		'show_cat_code',
		'show_expiry',
		'show_lot',
		'show_image',
		'show_sale_description',
		'sales_person_label',
		'show_sales_person',
		'table_product_label',
		'table_qty_label',
		'table_unit_price_label',
		'table_subtotal_label',
		'cat_code_label',
		'logo',
		'show_logo',
		'show_business_name',
		'show_location_name',
		'show_landmark',
		'show_city',
		'show_state',
		'show_zip_code',
		'show_country',
		'show_mobile_number',
		'show_alternate_number',
		'show_email',
		'show_tax_1',
		'show_tax_2',
		'show_barcode',
		'show_payments',
		'show_customer',
		'customer_label',
		'show_reward_point',
		'highlight_color',
		'footer_text',
		'module_info',
		'common_settings',
		'is_default',
		'business_id',
		'design',
		'cn_heading',
		'cn_no_label',
		'cn_amount_label',
		'table_tax_headings',
		'show_previous_bal',
		'prev_bal_label',
		'change_return_label',
		'product_custom_fields',
		'contact_custom_fields',
		'location_custom_fields'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	public function business_locations()
	{
		return $this->hasMany(BusinessLocation::class);
	}
}
