<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryProduct
 * 
 * @property int $id
 * @property int $inventaire_id
 * @property int|null $product_id
 * @property int|null $stock_theorique
 * @property int|null $stock_physique
 * @property float $ecart
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $observation
 * @property float|null $unit_price
 * @property float|null $sell_theoric
 * @property float|null $sell_physic
 *
 * @package App\Models
 */
class InventoryProduct extends Model
{
	protected $table = 'inventory_products';

	protected $casts = [
		'inventaire_id' => 'int',
		'product_id' => 'int',
		'stock_theorique' => 'int',
		'stock_physique' => 'int',
		'ecart' => 'float',
		'unit_price' => 'float',
		'sell_theoric' => 'float',
		'sell_physic' => 'float'
	];

	protected $fillable = [
		'inventaire_id',
		'product_id',
		'stock_theorique',
		'stock_physique',
		'ecart',
		'observation',
		'unit_price',
		'sell_theoric',
		'sell_physic'
	];
}
