<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Inventory
 * 
 * @property int $id
 * @property int $business_id
 * @property string $reference
 * @property string $invent
 * @property int|null $location_id
 * @property string $status
 * @property int $created_by
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property Carbon|null $inv_create_at
 * @property string|null $observation
 * @property float|null $sell_theoric_total
 * @property float|null $sell_physic_total
 *
 * @package App\Models
 */
class Inventory extends Model
{
	use SoftDeletes;
	protected $table = 'inventories';

	protected $casts = [
		'business_id' => 'int',
		'location_id' => 'int',
		'created_by' => 'int',
		'inv_create_at' => 'datetime',
		'sell_theoric_total' => 'float',
		'sell_physic_total' => 'float'
	];

	protected $fillable = [
		'business_id',
		'reference',
		'invent',
		'location_id',
		'status',
		'created_by',
		'inv_create_at',
		'observation',
		'sell_theoric_total',
		'sell_physic_total'
	];
}
