<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class GroupSubTax
 * 
 * @property int $group_tax_id
 * @property int $tax_id
 * 
 * @property TaxRate $tax_rate
 *
 * @package App\Models
 */
class GroupSubTax extends Model
{
	protected $table = 'group_sub_taxes';
	public $incrementing = false;
	public $timestamps = false;

	protected $casts = [
		'group_tax_id' => 'int',
		'tax_id' => 'int'
	];

	protected $fillable = [
		'group_tax_id',
		'tax_id'
	];

	public function tax_rate()
	{
		return $this->belongsTo(TaxRate::class, 'tax_id');
	}
}
