<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ExpenseCategory
 * 
 * @property int $id
 * @property string $name
 * @property int $business_id
 * @property string|null $code
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 *
 * @package App\Models
 */
class ExpenseCategory extends Model
{
	use SoftDeletes;
	protected $table = 'expense_categories';

	protected $casts = [
		'business_id' => 'int'
	];

	protected $fillable = [
		'name',
		'business_id',
		'code'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}
}
