<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DocumentAndNote
 * 
 * @property int $id
 * @property int $business_id
 * @property int $notable_id
 * @property string $notable_type
 * @property string|null $heading
 * @property string|null $description
 * @property bool $is_private
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class DocumentAndNote extends Model
{
	protected $table = 'document_and_notes';

	protected $casts = [
		'business_id' => 'int',
		'notable_id' => 'int',
		'is_private' => 'bool',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'notable_id',
		'notable_type',
		'heading',
		'description',
		'is_private',
		'created_by'
	];
}
