<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Discount
 * 
 * @property int $id
 * @property string $name
 * @property int $business_id
 * @property int|null $brand_id
 * @property int|null $category_id
 * @property int|null $location_id
 * @property int|null $priority
 * @property string|null $discount_type
 * @property float $discount_amount
 * @property Carbon|null $starts_at
 * @property Carbon|null $ends_at
 * @property bool $is_active
 * @property bool|null $applicable_in_spg
 * @property bool|null $applicable_in_cg
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Discount extends Model
{
	protected $table = 'discounts';

	protected $casts = [
		'business_id' => 'int',
		'brand_id' => 'int',
		'category_id' => 'int',
		'location_id' => 'int',
		'priority' => 'int',
		'discount_amount' => 'float',
		'starts_at' => 'datetime',
		'ends_at' => 'datetime',
		'is_active' => 'bool',
		'applicable_in_spg' => 'bool',
		'applicable_in_cg' => 'bool'
	];

	protected $fillable = [
		'name',
		'business_id',
		'brand_id',
		'category_id',
		'location_id',
		'priority',
		'discount_type',
		'discount_amount',
		'starts_at',
		'ends_at',
		'is_active',
		'applicable_in_spg',
		'applicable_in_cg'
	];
}
