<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DashboardConfiguration
 * 
 * @property int $id
 * @property int $business_id
 * @property int $created_by
 * @property string $name
 * @property string $color
 * @property string|null $configuration
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 *
 * @package App\Models
 */
class DashboardConfiguration extends Model
{
	protected $table = 'dashboard_configurations';

	protected $casts = [
		'business_id' => 'int',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'created_by',
		'name',
		'color',
		'configuration'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}
}
