<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CustomerGroup
 * 
 * @property int $id
 * @property int $business_id
 * @property string $name
 * @property float $amount
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 *
 * @package App\Models
 */
class CustomerGroup extends Model
{
	protected $table = 'customer_groups';

	protected $casts = [
		'business_id' => 'int',
		'amount' => 'float',
		'created_by' => 'int'
	];

	protected $fillable = [
		'business_id',
		'name',
		'amount',
		'created_by'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	/**
	 * Return list of customer group for a business
	 *
	 * @param $business_id int
	 * @param $prepend_none = true (boolean)
	 * @param $prepend_all = false (boolean)
	 *
	 * @return array
	 */
	public static function forDropdown($business_id, $prepend_none = true, $prepend_all = false)
	{
		$all_cg = CustomerGroup::where('business_id', $business_id);
		$all_cg = $all_cg->pluck('name', 'id');

		//Prepend none
		if ($prepend_none) {
			$all_cg = $all_cg->prepend(__("lang_v1.none"), '');
		}

		//Prepend none
		if ($prepend_all) {
			$all_cg = $all_cg->prepend(__("report.all"), '');
		}

		return $all_cg;
	}
}
