<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Currency
 * 
 * @property int $id
 * @property string $country
 * @property string $currency
 * @property string $code
 * @property string $symbol
 * @property string $thousand_separator
 * @property string $decimal_separator
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Collection|Business[] $businesses
 *
 * @package App\Models
 */
class Currency extends Model
{
	protected $table = 'currencies';

	protected $fillable = [
		'country',
		'currency',
		'code',
		'symbol',
		'thousand_separator',
		'decimal_separator'
	];

	public function businesses()
	{
		return $this->hasMany(Business::class);
	}
}
