<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CashRegisterTransaction
 * 
 * @property int $id
 * @property int $cash_register_id
 * @property float $amount
 * @property string|null $pay_method
 * @property string $type
 * @property string $transaction_type
 * @property int|null $transaction_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property CashRegister $cash_register
 *
 * @package App\Models
 */
class CashRegisterTransaction extends Model
{
	protected $table = 'cash_register_transactions';

	protected $casts = [
		'cash_register_id' => 'int',
		'amount' => 'float',
		'transaction_id' => 'int'
	];

	protected $fillable = [
		'cash_register_id',
		'amount',
		'pay_method',
		'type',
		'transaction_type',
		'transaction_id'
	];

	public function cash_register()
	{
		return $this->belongsTo(CashRegister::class);
	}
}
