<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CashRegister
 * 
 * @property int $id
 * @property int $business_id
 * @property int|null $location_id
 * @property int|null $user_id
 * @property string $status
 * @property Carbon|null $closed_at
 * @property float $closing_amount
 * @property int $total_card_slips
 * @property int $total_cheques
 * @property string|null $closing_note
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 * @property User|null $user
 * @property Collection|CashRegisterTransaction[] $cash_register_transactions
 *
 * @package App\Models
 */
class CashRegister extends Model
{
	protected $table = 'cash_registers';

	protected $casts = [
		'business_id' => 'int',
		'location_id' => 'int',
		'user_id' => 'int',
		'closed_at' => 'datetime',
		'closing_amount' => 'float',
		'total_card_slips' => 'int',
		'total_cheques' => 'int'
	];

	protected $fillable = [
		'business_id',
		'location_id',
		'user_id',
		'status',
		'closed_at',
		'closing_amount',
		'total_card_slips',
		'total_cheques',
		'closing_note'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function cash_register_transactions()
	{
		return $this->hasMany(CashRegisterTransaction::class);
	}
}
