<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class BusinessLocation
 * 
 * @property int $id
 * @property int $business_id
 * @property string|null $location_id
 * @property string $name
 * @property string|null $landmark
 * @property string $country
 * @property string $state
 * @property string $city
 * @property string $zip_code
 * @property int $invoice_scheme_id
 * @property int $invoice_layout_id
 * @property int|null $selling_price_group_id
 * @property bool|null $print_receipt_on_invoice
 * @property string $receipt_printer_type
 * @property int|null $printer_id
 * @property string|null $mobile
 * @property string|null $alternate_number
 * @property string|null $email
 * @property string|null $website
 * @property string|null $featured_products
 * @property bool $is_active
 * @property string|null $default_payment_accounts
 * @property string|null $custom_field1
 * @property string|null $custom_field2
 * @property string|null $custom_field3
 * @property string|null $custom_field4
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 * @property InvoiceLayout $invoice_layout
 * @property InvoiceScheme $invoice_scheme
 *
 * @package App\Models
 */
class BusinessLocation extends Model
{
	use SoftDeletes;
	protected $table = 'business_locations';

	protected $casts = [
		'business_id' => 'int',
		'invoice_scheme_id' => 'int',
		'invoice_layout_id' => 'int',
		'selling_price_group_id' => 'int',
		'print_receipt_on_invoice' => 'bool',
		'printer_id' => 'int',
		'is_active' => 'bool',
		'ref_no_prefixes' => 'array',
		'enabled_modules' => 'array',
		'email_settings' => 'array',
		'sms_settings' => 'array',
		'common_settings' => 'array',
		'weighing_scale_setting' => 'array'
	];

	/**
	 * Returns the date formats
	 */
	public static function date_formats()
	{
		return [
			'd-m-Y' => 'dd-mm-yyyy',
			'm-d-Y' => 'mm-dd-yyyy',
			'd/m/Y' => 'dd/mm/yyyy',
			'm/d/Y' => 'mm/dd/yyyy'
		];
	}

	protected $fillable = [
		'business_id',
		'location_id',
		'name',
		'landmark',
		'country',
		'state',
		'city',
		'zip_code',
		'invoice_scheme_id',
		'invoice_layout_id',
		'selling_price_group_id',
		'print_receipt_on_invoice',
		'receipt_printer_type',
		'printer_id',
		'mobile',
		'alternate_number',
		'email',
		'website',
		'featured_products',
		'is_active',
		'default_payment_accounts',
		'custom_field1',
		'custom_field2',
		'custom_field3',
		'custom_field4'
	];


	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	public function invoice_layout()
	{
		return $this->belongsTo(InvoiceLayout::class);
	}

	public function invoice_scheme()
	{
		return $this->belongsTo(InvoiceScheme::class);
	}

	/**
	 * Get the owner details
	 */
	public function owner()
	{
		return $this->hasOne(User::class, 'id', 'owner_id');
	}

	/**
	 * Get the Business currency.
	 */
	public function currency()
	{
		return $this->belongsTo(Currency::class);
	}

	/**
	 * Get the Business currency.
	 */
	public function locations()
	{
		return $this->hasMany(BusinessLocation::class);
	}

	/**
	 * Get the Business printers.
	 */
	public function printers()
	{
		return $this->hasMany(Printer::class);
	}

	/**
	 * Get the Business subscriptions.
	 */
	public function subscriptions()
	{
		return $this->hasMany('\Modules\Superadmin\Entities\Subscription');
	}

	/**
	 * Creates a new business based on the input provided.
	 *
	 * @return object
	 */
	public static function create_business($details)
	{
		$business = Business::create($details);
		return $business;
	}

	/**
	 * Updates a business based on the input provided.
	 * @param int $business_id
	 * @param array $details
	 *
	 * @return object
	 */
	public static function update_business($business_id, $details)
	{
		if (!empty($details)) {
			Business::where('id', $business_id)
				->update($details);
		}
	}

	public function getBusinessAddressAttribute()
	{
		$location = $this->locations->first();
		$address = $location->landmark . ', ' . $location->city .
			', ' . $location->state . '<br>' . $location->country . ', ' . $location->zip_code;

		return $address;
	}
}
