<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Business
 * 
 * @property int $id
 * @property string $name
 * @property int $currency_id
 * @property Carbon|null $start_date
 * @property string|null $tax_number_1
 * @property string|null $tax_label_1
 * @property string|null $tax_number_2
 * @property string|null $tax_label_2
 * @property int|null $default_sales_tax
 * @property float $default_profit_percent
 * @property int $owner_id
 * @property string $time_zone
 * @property int $fy_start_month
 * @property string $accounting_method
 * @property float|null $default_sales_discount
 * @property string $sell_price_tax
 * @property string|null $logo
 * @property string|null $sku_prefix
 * @property bool $enable_product_expiry
 * @property string $expiry_type
 * @property string $on_product_expiry
 * @property int $stop_selling_before
 * @property bool $enable_tooltip
 * @property bool $purchase_in_diff_currency
 * @property int|null $purchase_currency_id
 * @property float $p_exchange_rate
 * @property int $transaction_edit_days
 * @property int $stock_expiry_alert_days
 * @property string|null $keyboard_shortcuts
 * @property string|null $pos_settings
 * @property string $weighing_scale_setting
 * @property bool $enable_brand
 * @property bool $enable_category
 * @property bool $enable_sub_category
 * @property bool $enable_price_tax
 * @property bool|null $enable_purchase_status
 * @property bool $enable_lot_number
 * @property int|null $default_unit
 * @property bool $enable_sub_units
 * @property bool $enable_racks
 * @property bool $enable_row
 * @property bool $enable_position
 * @property bool $enable_editing_product_from_purchase
 * @property string|null $sales_cmsn_agnt
 * @property bool $item_addition_method
 * @property bool $enable_inline_tax
 * @property string $currency_symbol_placement
 * @property string|null $enabled_modules
 * @property string $date_format
 * @property string $time_format
 * @property string|null $ref_no_prefixes
 * @property string|null $theme_color
 * @property int|null $created_by
 * @property bool $enable_rp
 * @property string|null $rp_name
 * @property float $amount_for_unit_rp
 * @property float $min_order_total_for_rp
 * @property int|null $max_rp_per_order
 * @property float $redeem_amount_per_unit_rp
 * @property float $min_order_total_for_redeem
 * @property int|null $min_redeem_point
 * @property int|null $max_redeem_point
 * @property int|null $rp_expiry_period
 * @property string $rp_expiry_type
 * @property string|null $email_settings
 * @property string|null $sms_settings
 * @property string|null $custom_labels
 * @property string|null $common_settings
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Currency $currency
 * @property TaxRate|null $tax_rate
 * @property User $user
 * @property Collection|Barcode[] $barcodes
 * @property Collection|Booking[] $bookings
 * @property Collection|Brand[] $brands
 * @property Collection|BusinessLocation[] $business_locations
 * @property Collection|CashRegister[] $cash_registers
 * @property Collection|Category[] $categories
 * @property Collection|Contact[] $contacts
 * @property Collection|CustomerGroup[] $customer_groups
 * @property Collection|DashboardConfiguration[] $dashboard_configurations
 * @property Collection|ExpenseCategory[] $expense_categories
 * @property Collection|InvoiceLayout[] $invoice_layouts
 * @property Collection|InvoiceScheme[] $invoice_schemes
 * @property Collection|Printer[] $printers
 *
 * @package App\Models
 */
class Business extends Model
{
	protected $table = 'business';

	protected $casts = [
		'currency_id' => 'int',
		'start_date' => 'datetime',
		'default_sales_tax' => 'int',
		'default_profit_percent' => 'float',
		'owner_id' => 'int',
		'fy_start_month' => 'int',
		'default_sales_discount' => 'float',
		'enable_product_expiry' => 'bool',
		'stop_selling_before' => 'int',
		'enable_tooltip' => 'bool',
		'purchase_in_diff_currency' => 'bool',
		'purchase_currency_id' => 'int',
		'p_exchange_rate' => 'float',
		'transaction_edit_days' => 'int',
		'stock_expiry_alert_days' => 'int',
		'enable_brand' => 'bool',
		'enable_category' => 'bool',
		'enable_sub_category' => 'bool',
		'enable_price_tax' => 'bool',
		'enable_purchase_status' => 'bool',
		'enable_lot_number' => 'bool',
		'default_unit' => 'int',
		'enable_sub_units' => 'bool',
		'enable_racks' => 'bool',
		'enable_row' => 'bool',
		'enable_position' => 'bool',
		'enable_editing_product_from_purchase' => 'bool',
		'item_addition_method' => 'bool',
		'enable_inline_tax' => 'bool',
		'created_by' => 'int',
		'enable_rp' => 'bool',
		'amount_for_unit_rp' => 'float',
		'min_order_total_for_rp' => 'float',
		'max_rp_per_order' => 'int',
		'redeem_amount_per_unit_rp' => 'float',
		'min_order_total_for_redeem' => 'float',
		'min_redeem_point' => 'int',
		'max_redeem_point' => 'int',
		'rp_expiry_period' => 'int',
		'is_active' => 'bool',
		'ref_no_prefixes' => 'array',
		'enabled_modules' => 'array',
		'email_settings' => 'array',
		'sms_settings' => 'array',
		'common_settings' => 'array',
		'weighing_scale_setting' => 'array'
	];

	protected $fillable = [
		'name',
		'currency_id',
		'start_date',
		'tax_number_1',
		'tax_label_1',
		'tax_number_2',
		'tax_label_2',
		'default_sales_tax',
		'default_profit_percent',
		'owner_id',
		'time_zone',
		'fy_start_month',
		'accounting_method',
		'default_sales_discount',
		'sell_price_tax',
		'logo',
		'sku_prefix',
		'enable_product_expiry',
		'expiry_type',
		'on_product_expiry',
		'stop_selling_before',
		'enable_tooltip',
		'purchase_in_diff_currency',
		'purchase_currency_id',
		'p_exchange_rate',
		'transaction_edit_days',
		'stock_expiry_alert_days',
		'keyboard_shortcuts',
		'pos_settings',
		'weighing_scale_setting',
		'enable_brand',
		'enable_category',
		'enable_sub_category',
		'enable_price_tax',
		'enable_purchase_status',
		'enable_lot_number',
		'default_unit',
		'enable_sub_units',
		'enable_racks',
		'enable_row',
		'enable_position',
		'enable_editing_product_from_purchase',
		'sales_cmsn_agnt',
		'item_addition_method',
		'enable_inline_tax',
		'currency_symbol_placement',
		'enabled_modules',
		'date_format',
		'time_format',
		'ref_no_prefixes',
		'theme_color',
		'created_by',
		'enable_rp',
		'rp_name',
		'amount_for_unit_rp',
		'min_order_total_for_rp',
		'max_rp_per_order',
		'redeem_amount_per_unit_rp',
		'min_order_total_for_redeem',
		'min_redeem_point',
		'max_redeem_point',
		'rp_expiry_period',
		'rp_expiry_type',
		'email_settings',
		'sms_settings',
		'custom_labels',
		'common_settings',
		'is_active'
	];

	public function currency()
	{
		return $this->belongsTo(Currency::class);
	}

	public function tax_rate()
	{
		return $this->belongsTo(TaxRate::class, 'default_sales_tax');
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'owner_id');
	}

	public function barcodes()
	{
		return $this->hasMany(Barcode::class);
	}

	public function bookings()
	{
		return $this->hasMany(Booking::class);
	}

	public function brands()
	{
		return $this->hasMany(Brand::class);
	}

	public function business_locations()
	{
		return $this->hasMany(BusinessLocation::class);
	}

	public function cash_registers()
	{
		return $this->hasMany(CashRegister::class);
	}

	public function categories()
	{
		return $this->hasMany(Category::class);
	}

	public function contacts()
	{
		return $this->hasMany(Contact::class);
	}

	public function customer_groups()
	{
		return $this->hasMany(CustomerGroup::class);
	}

	public function dashboard_configurations()
	{
		return $this->hasMany(DashboardConfiguration::class);
	}

	public function expense_categories()
	{
		return $this->hasMany(ExpenseCategory::class);
	}

	public function invoice_layouts()
	{
		return $this->hasMany(InvoiceLayout::class);
	}

	public function invoice_schemes()
	{
		return $this->hasMany(InvoiceScheme::class);
	}

	public function printers()
	{
		return $this->hasMany(Printer::class);
	}

	/**
	 * Get the owner details
	 */
	public function owner()
	{
		return $this->hasOne(User::class, 'id', 'owner_id');
	}

	/**
	 * Get the Business currency.
	 */
	public function locations()
	{
		return $this->hasMany(BusinessLocation::class);
	}


	/**
	 * Get the Business subscriptions.
	 */
	public function subscriptions()
	{
		return $this->hasMany('\Modules\Superadmin\Entities\Subscription');
	}

	/**
	 * Creates a new business based on the input provided.
	 *
	 * @return object
	 */
	public static function create_business($details)
	{
		$business = Business::create($details);
		return $business;
	}

	/**
	 * Updates a business based on the input provided.
	 * @param int $business_id
	 * @param array $details
	 *
	 * @return object
	 */
	public static function update_business($business_id, $details)
	{
		if (!empty($details)) {
			Business::where('id', $business_id)
				->update($details);
		}
	}

	public function getBusinessAddressAttribute()
	{
		$location = $this->locations->first();
		$address = $location->landmark . ', ' . $location->city .
			', ' . $location->state . '<br>' . $location->country . ', ' . $location->zip_code;

		return $address;
	}
}
