<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Booking
 * 
 * @property int $id
 * @property int $contact_id
 * @property int|null $waiter_id
 * @property int|null $table_id
 * @property int|null $correspondent_id
 * @property int $business_id
 * @property int $location_id
 * @property Carbon $booking_start
 * @property Carbon $booking_end
 * @property int $created_by
 * @property string $booking_status
 * @property string|null $booking_note
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business $business
 * @property Contact $contact
 * @property User $user
 *
 * @package App\Models
 */
class Booking extends Model
{
	protected $table = 'bookings';

	protected $casts = [
		'contact_id' => 'int',
		'waiter_id' => 'int',
		'table_id' => 'int',
		'correspondent_id' => 'int',
		'business_id' => 'int',
		'location_id' => 'int',
		'booking_start' => 'datetime',
		'booking_end' => 'datetime',
		'created_by' => 'int'
	];

	protected $fillable = [
		'contact_id',
		'waiter_id',
		'table_id',
		'correspondent_id',
		'business_id',
		'location_id',
		'booking_start',
		'booking_end',
		'created_by',
		'booking_status',
		'booking_note'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}

	public function contact()
	{
		return $this->belongsTo(Contact::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}
}
