<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Barcode
 * 
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property float|null $width
 * @property float|null $height
 * @property float|null $paper_width
 * @property float|null $paper_height
 * @property float|null $top_margin
 * @property float|null $left_margin
 * @property float|null $row_distance
 * @property float|null $col_distance
 * @property int|null $stickers_in_one_row
 * @property bool $is_default
 * @property bool $is_continuous
 * @property int|null $stickers_in_one_sheet
 * @property int|null $business_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Business|null $business
 *
 * @package App\Models
 */
class Barcode extends Model
{
	protected $table = 'barcodes';

	protected $casts = [
		'width' => 'float',
		'height' => 'float',
		'paper_width' => 'float',
		'paper_height' => 'float',
		'top_margin' => 'float',
		'left_margin' => 'float',
		'row_distance' => 'float',
		'col_distance' => 'float',
		'stickers_in_one_row' => 'int',
		'is_default' => 'bool',
		'is_continuous' => 'bool',
		'stickers_in_one_sheet' => 'int',
		'business_id' => 'int'
	];

	protected $fillable = [
		'name',
		'description',
		'width',
		'height',
		'paper_width',
		'paper_height',
		'top_margin',
		'left_margin',
		'row_distance',
		'col_distance',
		'stickers_in_one_row',
		'is_default',
		'is_continuous',
		'stickers_in_one_sheet',
		'business_id'
	];

	public function business()
	{
		return $this->belongsTo(Business::class);
	}
}
