<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class AccountType
 * 
 * @property int $id
 * @property string $name
 * @property int|null $parent_account_type_id
 * @property int $business_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class AccountType extends Model
{
	protected $table = 'account_types';

	protected $casts = [
		'parent_account_type_id' => 'int',
		'business_id' => 'int'
	];

	protected $fillable = [
		'name',
		'parent_account_type_id',
		'business_id'
	];
}
