<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class AccountTransaction
 * 
 * @property int $id
 * @property int $account_id
 * @property string $type
 * @property string|null $sub_type
 * @property float $amount
 * @property string|null $reff_no
 * @property Carbon $operation_date
 * @property int $created_by
 * @property int|null $transaction_id
 * @property int|null $transaction_payment_id
 * @property int|null $transfer_transaction_id
 * @property string|null $note
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class AccountTransaction extends Model
{
	use SoftDeletes;
	protected $table = 'account_transactions';

	protected $casts = [
		'account_id' => 'int',
		'amount' => 'float',
		'operation_date' => 'datetime',
		'created_by' => 'int',
		'transaction_id' => 'int',
		'transaction_payment_id' => 'int',
		'transfer_transaction_id' => 'int'
	];

	protected $fillable = [
		'account_id',
		'type',
		'sub_type',
		'amount',
		'reff_no',
		'operation_date',
		'created_by',
		'transaction_id',
		'transaction_payment_id',
		'transfer_transaction_id',
		'note'
	];
}
