<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Account
 * 
 * @property int $id
 * @property int $business_id
 * @property string $name
 * @property string $account_number
 * @property int|null $account_type_id
 * @property string|null $note
 * @property int $created_by
 * @property bool $is_closed
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Account extends Model
{
	use SoftDeletes;
	protected $table = 'accounts';

	protected $casts = [
		'business_id' => 'int',
		'account_type_id' => 'int',
		'created_by' => 'int',
		'is_closed' => 'bool'
	];

	protected $fillable = [
		'business_id',
		'name',
		'account_number',
		'account_type_id',
		'note',
		'created_by',
		'is_closed'
	];
}
